function R = Angle2RotMtx(omega)
% R = Angle2RotM(omega)
%
% This function generates the rotation matrix using the Euler angles.
%
% Inputs:
%   omega:    (3 x 1), Euler angles
%
% Outputs:
%   R:        (3 x 3), rotation matrix

alp = omega(1); 
beta = omega(2); 
gamma = omega(3);
R_alp = [1,0,0;
         0,cos(alp),-sin(alp);
         0,sin(alp),cos(alp)];
R_beta = [cos(beta),0,-sin(beta);
          0,1,0;
          sin(beta),0,cos(beta)];
R_gamma = [cos(gamma),-sin(gamma),0;
           sin(gamma),cos(gamma),0,
           0,0,1];
R = R_gamma*R_beta*R_alp;
end
